<?php
require_once __DIR__ . '/../app/core/db.php';
require_once __DIR__ . '/../app/core/audit.php';

$cut = date('Y-m-d H:i:s', time() - 180*24*3600); // 180 days
$old = db_all("SELECT id, tenant_id, file_path FROM backups WHERE status='success' AND finished_at < ?", [$cut]);

foreach ($old as $b) {
  $path = $b['file_path'];
  if ($path && file_exists($path)) @unlink($path);
  db_exec("DELETE FROM backups WHERE id=?", [(int)$b['id']]);
  audit_log((int)$b['tenant_id'], null, 'BACKUP_PURGED_RETENTION', 'backup', (int)$b['id'], ['cutoff'=>$cut]);
}
