<?php
require_once __DIR__ . '/../app/core/db.php';
require_once __DIR__ . '/../app/core/audit.php';

$rows = db_all("SELECT d.* FROM devices d
               JOIN tenants t ON t.id=d.tenant_id
               WHERE d.deleted_at IS NULL AND d.enabled=1 AND t.status='ACTIVE'
                 AND (d.next_due_at IS NULL OR d.next_due_at <= NOW())");

foreach ($rows as $d) {
  // enqueue schedule backup if not already pending/running in last 30 minutes
  $recent = db_one("SELECT id FROM backups WHERE device_id=? AND status IN ('pending','running') AND created_at >= DATE_SUB(NOW(), INTERVAL 30 MINUTE) LIMIT 1", [(int)$d['id']]);
  if ($recent) continue;

  db_exec("INSERT INTO backups (tenant_id,device_id,trigger_source,status,scheduled_at) VALUES (?,?,?,?,NOW())",
    [(int)$d['tenant_id'], (int)$d['id'], 'schedule', 'pending']
  );
  audit_log((int)$d['tenant_id'], null, 'BACKUP_SCHEDULED', 'device', (int)$d['id'], []);
}
