<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Payment Gateway (bKash) Settings</h2>
    <?php if (!empty($_GET['msg'])): ?><div class="banner">Saved.</div><?php endif; ?>

    <form method="post" action="index.php">
      <input type="hidden" name="action" value="pgw_settings_update">

      <label style="display:block;margin-bottom:10px;">
        <input type="checkbox" name="bkash_enabled" <?= ($data['bkash_enabled']==='1'?'checked':'') ?>>
        Enable bKash payment
      </label>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
        <div>
          <label>External Pay URL (optional)</label><br>
          <input name="bkash_pay_url" value="<?= h($data['bkash_pay_url']) ?>" placeholder="https://pay.example.com/checkout"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
          <div style="font-size:12px;color:#6b7280;margin-top:4px;">
            যদি আপনি external checkout URL ব্যবহার করেন, সিস্টেম invoice_id, amount, tenant_id querystring হিসেবে পাঠাবে।
          </div>
        </div>

        <div>
          <label>Note (shown on invoice pay page)</label><br>
          <input name="bkash_note" value="<?= h($data['bkash_note']) ?>"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>

        <div>
          <label>Success URL (optional)</label><br>
          <input name="bkash_success_url" value="<?= h($data['bkash_success_url']) ?>" placeholder="https://backup.apzone.top/?action=pay_success&invoice_id=..."
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>

        <div>
          <label>Fail URL (optional)</label><br>
          <input name="bkash_fail_url" value="<?= h($data['bkash_fail_url']) ?>"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>
      </div>

      <div style="margin-top:12px;">
        <button class="btn primary" type="submit">Save</button>
      </div>
    </form>

    <div class="card" style="margin-top:12px;background:#f8fafc;">
      <h3>How Pay Link Works</h3>
      <p style="color:#374151;line-height:1.6;">
        Invoice Pay page থেকে “Pay Now” চাপলে:
      </p>
      <ul style="color:#374151;line-height:1.8;">
        <li>যদি External Pay URL দেওয়া থাকে, user redirect হবে: <code>bkash_pay_url?invoice_id=...&tenant_id=...&amount=...</code></li>
        <li>না থাকলে, demo mode হিসেবে system নিজে “Mark as Paid” বাটন দেখাবে (testing)</li>
      </ul>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
