<?php
require_once __DIR__ . '/layout/header.php';
require_once __DIR__ . '/layout/sidebar.php';
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/guard.php';
$u = require_login();
require_tenant_active_or_invoice($u, is_super($u)); // super can always
?>
<div class="main">
<?php
$u = require_login();
if (!is_super($u) && !empty($u['tenant_id'])) {
  $latestDue = db_one("SELECT id, total_amount, due_date FROM invoices WHERE tenant_id=? AND status='UNPAID' ORDER BY due_date ASC LIMIT 1", [(int)$u['tenant_id']]);
  if ($latestDue) {
    $isOver = (strtotime($latestDue['due_date']) < time());
?>
  <div class="banner" style="background:<?= $isOver ? '#fff7ed' : '#ecfeff' ?>;border-color:<?= $isOver ? '#fdba74' : '#67e8f9' ?>;">
    <b><?= $isOver ? 'Invoice overdue' : 'Invoice due' ?></b> — Invoice #<?= (int)$latestDue['id'] ?> | Amount <?= h($latestDue['total_amount']) ?> | Due <?= h($latestDue['due_date']) ?>
    <a class="btn primary" style="margin-left:10px;" href="index.php?page=invoice_pay&id=<?= (int)$latestDue['id'] ?>">Pay now</a>
  </div>
<?php }} ?>


<?php
$u = require_login();
$ym = date('Y-m');
if (is_super($u)) {
  $tenants_total = db_one("SELECT COUNT(*) c FROM tenants")['c'] ?? 0;
  $devices_total = db_one("SELECT COUNT(*) c FROM devices WHERE deleted_at IS NULL")['c'] ?? 0;
  $expected = db_one("SELECT COALESCE(SUM(total_amount),0) s FROM invoices WHERE period_ym=?", [$ym])['s'] ?? 0;
  $collected = db_one("SELECT COALESCE(SUM(total_amount),0) s FROM invoices WHERE period_ym=? AND status='PAID'", [$ym])['s'] ?? 0;
  $due = (float)$expected - (float)$collected;
?>
  <div class="card">
    <h3>Super Admin Overview (<?= h($ym) ?>)</h3>
    <div style="display:grid;grid-template-columns:repeat(4,1fr);gap:10px;">
      <div class="stat"><b>Total Tenants</b><div><?= (int)$tenants_total ?></div></div>
      <div class="stat"><b>Total Devices</b><div><?= (int)$devices_total ?></div></div>
      <div class="stat"><b>Expected collection</b><div><?= h($expected) ?></div></div>
      <div class="stat"><b>Collected</b><div><?= h($collected) ?></div><div style="color:#6b7280;font-size:12px;">Due: <?= h($due) ?></div></div>
    </div>
  </div>
<?php } ?>

  <div class="card">
    <h2>Dashboard</h2>
    <?php if (!is_super($u)): 
      $t = db_one("SELECT * FROM tenants WHERE id=?", [(int)$u['tenant_id']]);
      if ($t && $t['status'] !== 'ACTIVE'): ?>
        <div class="banner">
          Due to unpaid invoice your billing activities temporarily suspended.
          <a class="btn primary" href="index.php?page=invoices">Pay Now</a>
        </div>
      <?php endif; endif; ?>

    <?php if (is_super($u)): 
      $totTen = db_one("SELECT COUNT(*) c FROM tenants")['c'] ?? 0;
      $totDev = db_one("SELECT COUNT(*) c FROM devices WHERE deleted_at IS NULL")['c'] ?? 0;
      $exp = db_one("SELECT SUM(total_amount) s FROM invoices WHERE period_ym=?",
        [date('Y-m')])['s'] ?? 0;
      $col = db_one("SELECT SUM(total_amount) s FROM invoices WHERE period_ym=? AND status='PAID'",
        [date('Y-m')])['s'] ?? 0;
      $failToday = db_one("SELECT COUNT(*) c FROM backups WHERE status='failed' AND DATE(created_at)=CURDATE()")['c'] ?? 0;
    ?>
      <p>Total tenants: <b><?= (int)$totTen ?></b> | Total devices: <b><?= (int)$totDev ?></b></p>
      <p>This month expected: <b><?= (int)$exp ?></b> | Collected: <b><?= (int)$col ?></b></p>
      <p>Failed backups today: <b><?= (int)$failToday ?></b></p>
    <?php else:
      $tid=(int)$u['tenant_id'];
      $dev = db_one("SELECT COUNT(*) c FROM devices WHERE tenant_id=? AND deleted_at IS NULL",[$tid])['c'] ?? 0;
      $fail = db_one("SELECT COUNT(*) c FROM backups WHERE tenant_id=? AND status='failed' AND DATE(created_at)=CURDATE()",[$tid])['c'] ?? 0;
      $succ = db_one("SELECT COUNT(*) c FROM backups WHERE tenant_id=? AND status='success' AND DATE(created_at)=CURDATE()",[$tid])['c'] ?? 0;
      $unpaid = db_one("SELECT id,total_amount,due_date FROM invoices WHERE tenant_id=? AND status='UNPAID' ORDER BY id DESC LIMIT 1",[$tid]);
    ?>
      <p>Your devices: <b><?= (int)$dev ?></b></p>
      <p>Backups today: ✅ <b><?= (int)$succ ?></b> | ❌ <b><?= (int)$fail ?></b></p>
      <?php if ($unpaid): ?>
        <div class="banner">
          Unpaid invoice: <b>#<?= (int)$unpaid['id'] ?></b> Amount: <b><?= (int)$unpaid['total_amount'] ?></b> Due: <b><?= h($unpaid['due_date']) ?></b>
          <a class="btn primary" href="index.php?page=invoice_pay&id=<?= (int)$unpaid['id'] ?>">Pay Now</a>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>
</div>
<?php require_once __DIR__ . '/layout/footer.php'; ?>
