<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
require_once __DIR__ . '/../../core/pgw_bkash.php';
require_once __DIR__ . '/../../core/settings.php';

$pgw = bkash_settings_get();
$enabled = ($pgw['bkash_enabled'] ?? '0') === '1';
$externalPayUrl = trim((string)($pgw['bkash_pay_url'] ?? ''));
$note = setting_get('GLOBAL', null, 'bkash_note', 'Pay to re-enable service');
$externalLink = bkash_create_payment_link((int)$inv['id']);
?>
<div class="main">
  <div class="card">
    <h2>Pay Invoice #<?= (int)$inv['id'] ?></h2>
    <p>Amount: <b><?= h($inv['total_amount']) ?></b> | Due: <b><?= h($inv['due_date']) ?></b></p>

    <?php if (!empty($_GET['err']) && $_GET['err']==='failed'): ?>
      <div class="banner" style="background:#fff7ed;border-color:#fdba74;">Payment failed/cancelled. Please try again.</div>
    <?php endif; ?>

    <div class="banner">
      <?= nl2br(h($note)) ?>
    </div>

    <?php if ($enabled && $externalPayUrl): ?>
      <a class="btn primary" href="<?= h($externalLink) ?>">Pay Now (bKash)</a>
      <div style="margin-top:10px;color:#6b7280;font-size:12px;">
        You will be redirected to external checkout. After success, system will auto-enable service.
      </div>
    <?php else: ?>
      <div style="margin-top:10px;color:#6b7280;">
        bKash external checkout URL not configured. Demo mode:
      </div>
      <form method="get" action="index.php" style="margin-top:10px;">
        <input type="hidden" name="action" value="pay_success">
        <input type="hidden" name="id" value="<?= (int)$inv['id'] ?>">
        <button class="btn primary" type="submit">Mark as Paid (Demo)</button>
      </form>
    <?php endif; ?>

    <a class="btn" href="index.php?page=invoices" style="margin-top:10px;">Back</a>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
