<?php
/**
 * bKash PGW helper (lightweight).
 * This project can work in two modes:
 * 1) External Checkout URL mode (recommended for now): redirect to a pay URL you provide.
 * 2) Demo mode: show "Mark as Paid" for testing.
 *
 * Configure in SuperAdmin → Settings → Payment Gateway:
 * - bkash_enabled (1/0)
 * - bkash_pay_url (external checkout URL)
 */

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/settings.php';
require_once __DIR__ . '/helpers.php';

function bkash_settings_get(): array {
  $rows = db_all("SELECT k,v FROM settings WHERE scope='GLOBAL' AND k LIKE 'bkash_%'");
  $out = [];
  foreach ($rows as $r) $out[$r['k']] = $r['v'];
  return $out;
}

function bkash_create_payment_link(int $invoice_id): string {
  $s = bkash_settings_get();
  $enabled = (($s['bkash_enabled'] ?? '0') === '1');
  $payUrl = trim((string)($s['bkash_pay_url'] ?? ''));

  if ($enabled && $payUrl) {
    $inv = db_one("SELECT id, tenant_id, total_amount FROM invoices WHERE id=?", [$invoice_id]);
    if (!$inv) return "index.php?page=invoices";

    $base = site_url(); // resolves to scheme://host(/public if any)
    $qs = http_build_query([
      'invoice_id' => (int)$inv['id'],
      'tenant_id'  => (int)$inv['tenant_id'],
      'amount'     => (float)$inv['total_amount'],
      'success'    => $base . "/index.php?action=pay_success&id=" . (int)$inv['id'],
      'fail'       => $base . "/index.php?page=invoice_pay&id=" . (int)$inv['id'] . "&err=failed",
    ]);

    $hasQ = (strpos($payUrl, '?') !== false);
    return rtrim($payUrl, '?&') . ($hasQ ? '&' : '?') . $qs;
  }

  // fallback: internal pay page (demo)
  return "index.php?page=invoice_pay&id=" . $invoice_id;
}
