<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function tenant_row(int $tenant_id): ?array {
  return db_one("SELECT * FROM tenants WHERE id=?", [$tenant_id]);
}

function require_tenant_active_or_invoice(array $u, bool $invoice_page=false): void {
  if (is_super($u)) return;
  $tid = tenant_id_of($u);
  if (!$tid) return;

  $t = tenant_row($tid);
  if (!$t) { http_response_code(403); exit('Tenant not found'); }

  if ($t['status'] !== 'ACTIVE') {
    if ($invoice_page) return;
    http_response_code(403);
    exit('Due to unpaid invoice your billing activities temporarily suspended. Pay Now.');
  }
}

function can_device_delete(array $u, array $tenant): bool {
  if (is_super($u)) return true;
  if (is_tenant_staff($u)) return false;
  if (is_tenant_admin($u) && (int)$tenant['allow_admin_device_delete'] === 1) return true;
  return false;
}

function can_backup_delete(array $u, array $tenant): bool {
  if (is_super($u)) return true;
  if (is_tenant_staff($u)) return false;
  if (is_tenant_admin($u) && (int)$tenant['allow_admin_backup_delete'] === 1) return true;
  return false;
}

function can_manual_backup(array $u, array $tenant): bool {
  if (is_super($u)) return true;
  if (is_tenant_staff($u)) return false;
  if (is_tenant_admin($u) && (int)$tenant['allow_admin_manual_backup'] === 1) return true;
  return false;
}
