<?php
require_once __DIR__ . '/../app/core/auth.php';
require_once __DIR__ . '/../app/core/helpers.php';

require_once __DIR__ . '/../app/controllers/auth_controller.php';
require_once __DIR__ . '/../app/controllers/device_controller.php';
require_once __DIR__ . '/../app/controllers/backup_controller.php';
require_once __DIR__ . '/../app/controllers/tenant_controller.php';
require_once __DIR__ . '/../app/controllers/billing_controller.php';
require_once __DIR__ . '/../app/controllers/settings_controller.php';
require_once __DIR__ . '/../app/controllers/staff_controller.php';

session_start_safe();

$action = $_POST['action'] ?? ($_GET['action'] ?? null);
$page = $_GET['page'] ?? null;

if ($action === 'login') { auth_login_action(); exit; }
if ($page === 'logout') { auth_logout_action(); exit; }

if ($action === 'device_create') { device_create_action(); exit; }
if ($action === 'device_delete') { device_delete_action(); exit; }
if ($action === 'tenant_update') { tenant_update_action(); exit; }
if ($action === 'tenant_create') { tenant_create_action(); exit; }
if ($action === 'tenant_admin_reset_password') { tenant_admin_reset_password_action(); exit; }
if ($action === 'invoice_adjust') { invoice_add_adjustment_action(); exit; }
if ($action === 'site_settings_update') { site_settings_update_action(); exit; }
if ($action === 'staff_create') { staff_create_action(); exit; }
if ($action === 'staff_toggle') { staff_toggle_action(); exit; }
if ($action === 'staff_reset_password') { staff_reset_password_action(); exit; }
if ($action === 'pay_success') { invoice_pay_success_action(); exit; }
if ($action === 'backup_download') { backup_download_action(); exit; }
if ($action === 'backup_delete') { backup_delete_action(); exit; }

$u = current_user();

// SUSPENDED_UNPAID guard (tenant can login + pay only)
if ($u && !is_super($u) && is_tenant_suspended_unpaid($u)) {
  $allowPages = ['invoices','invoice_pay','logout'];
  $allowActions = ['pay_success'];
  if ($page === 'dashboard') { redirect('index.php?page=invoices&due=1'); }
  if ($page && !in_array($page, $allowPages, true)) {
    redirect('index.php?page=invoices&due=1');
  }
  if ($action && !in_array($action, $allowActions, true)) {
    redirect('index.php?page=invoices&due=1');
  }
}

if (!$page) {
  $page = $u ? 'dashboard' : 'login';
}
switch ($page) {
  case 'login':
    auth_login_page(null);
    break;

  case 'dashboard':
    include __DIR__ . '/../app/views/dashboard.php';
    break;

  case 'devices':
    devices_page();
    break;

  case 'backups_browse':
    if (!is_super(require_login())) {
      $_GET['tenant_id'] = tenant_id_of(require_login());
    }
    backups_browse_page();
    break;

  case 'backup_preview':
    backup_preview_page();
    break;

  case 'tenants':
    tenants_page();
    break;

  case 'tenant_edit':
    tenant_edit_page();
    break;

  case 'invoices':
    invoices_page();
    break;

  case 'invoice_pay':
    invoice_pay_page();
    break;

  case 'site_settings':
    site_settings_page();
    break;

  case 'staff':
    staff_page();
    break;

  default:
    http_response_code(404);
    echo "Not found";
}
