<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Tenants</h2>

    <?php if (!empty($_GET['msg']) && $_GET['msg']==='created'): ?>
      <div class="banner">Tenant created successfully.</div>
    <?php endif; ?>
    <?php if (!empty($_GET['msg']) && $_GET['msg']==='updated'): ?>
      <div class="banner">Tenant updated successfully.</div>
    <?php endif; ?>

    <div class="card" style="background:#f8fafc;">
      <h3>Add Tenant</h3>
      <form method="post" action="index.php">
        <input type="hidden" name="action" value="tenant_create">

        <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
          <div>
            <label>Tenant Name</label><br>
            <input name="name" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;" placeholder="Company / ISP name">
          </div>
          <div>
            <label>Status</label><br>
            <select name="status" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
              <option value="ACTIVE">ACTIVE</option>
              <option value="SUSPENDED_UNPAID">SUSPENDED_UNPAID</option>
              <option value="DISABLED">DISABLED</option>
            </select>
          </div>

          <div>
            <label>Tenant Admin Username</label><br>
            <input name="admin_username" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;" placeholder="e.g. isp_admin">
          </div>
          <div>
            <label>Tenant Admin Password</label><br>
            <input type="password" name="admin_password" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;" placeholder="Set a strong password">
          </div>
        </div>

        <div class="card" style="margin-top:12px;background:#fff;">
          <h4 style="margin-top:0;">Policies</h4>
          <label><input type="checkbox" name="allow_admin_device_delete"> Allow Tenant Admin to Delete Devices</label><br>
          <label><input type="checkbox" name="allow_admin_backup_delete"> Allow Tenant Admin to Delete Backups</label><br>
          <label><input type="checkbox" name="purge_files_on_device_delete" checked> When Device Deleted → Purge All Backup Files</label><br>
          <label><input type="checkbox" name="allow_admin_manual_backup" checked> Allow Tenant Admin Manual Backup</label><br>
          <div style="margin-top:8px;color:#6b7280;font-size:12px;">
            Tenant staff can never delete devices/backups (hard rule).
          </div>
        </div>

        <button class="btn primary" type="submit">Create Tenant</button>
      </form>
    </div>

    <h3 style="margin-top:16px;">Tenant List</h3>
    <table>
      <thead><tr><th>ID</th><th>Name</th><th>Status</th><th>Policies</th><th>Actions</th></tr></thead>
      <tbody>
      <?php foreach ($tenants as $t): ?>
        <tr>
          <td><?= (int)$t['id'] ?></td>
          <td><?= h($t['name']) ?></td>
          <td><?= h($t['status']) ?></td>
          <td>
            del_device=<?= (int)$t['allow_admin_device_delete'] ?>,
            del_backup=<?= (int)$t['allow_admin_backup_delete'] ?>
          </td>
          <td><a class="btn primary" href="index.php?page=tenant_edit&id=<?= (int)$t['id'] ?>">Edit</a></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
