<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Edit Tenant (Policies)</h2>
    <form method="post" action="index.php">
      <input type="hidden" name="action" value="tenant_update">
      <input type="hidden" name="id" value="<?= (int)$t['id'] ?>">

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
        <div>
          <label>Name</label><br>
          <input name="name" value="<?= h($t['name']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>
        <div>
          <label>Status</label><br>
          <select name="status" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <?php foreach (['ACTIVE','SUSPENDED_UNPAID','DISABLED'] as $st): ?>
              <option value="<?= $st ?>" <?= $t['status']===$st?'selected':'' ?>><?= $st ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div class="card" style="margin-top:12px;background:#f8fafc;">
        <h3>Policies</h3>
        <label><input type="checkbox" name="allow_admin_device_delete" <?= (int)$t['allow_admin_device_delete']===1?'checked':'' ?>> Allow Tenant Admin to Delete Devices</label><br>
        <label><input type="checkbox" name="allow_admin_backup_delete" <?= (int)$t['allow_admin_backup_delete']===1?'checked':'' ?>> Allow Tenant Admin to Delete Backups</label><br>
        <label><input type="checkbox" name="purge_files_on_device_delete" <?= (int)$t['purge_files_on_device_delete']===1?'checked':'' ?>> When Device Deleted → Purge All Backup Files</label><br>
        <label><input type="checkbox" name="allow_admin_manual_backup" <?= (int)$t['allow_admin_manual_backup']===1?'checked':'' ?>> Allow Tenant Admin Manual Backup</label><br>
        <div style="margin-top:8px;color:#6b7280;font-size:12px;">
          Tenant staff can never delete devices/backups (hard rule).
        </div>
      </div>

      <button class="btn primary" type="submit">Save</button>
      <a class="btn" href="index.php?page=tenants">Back</a>
    </form>
  </div>
</div>

  <?php if (is_super($u)): ?>
  <div class="card" style="margin-top:12px;">
    <h3>Reset Tenant Admin Password</h3>
    <form method="post" action="index.php" onsubmit="return confirm('Reset tenant admin password?');">
      <input type="hidden" name="action" value="tenant_admin_reset_password">
      <input type="hidden" name="tenant_id" value="<?= (int)$tenant['id'] ?>">
      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
        <div>
          <label>Tenant Admin Username</label><br>
          <input name="admin_username" placeholder="existing tenant admin username" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
          <div style="font-size:12px;color:#6b7280;margin-top:4px;">(Optional) ফাঁকা রাখলে tenant-এর প্রথম tenant_admin ধরা হবে।</div>
        </div>
        <div>
          <label>New Password</label><br>
          <input type="password" name="new_password" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>
      </div>
      <button class="btn primary" type="submit" style="margin-top:10px;">Reset Password</button>
    </form>
  </div>
  <?php endif; ?>

<?php require_once __DIR__ . '/../layout/footer.php'; ?>

