<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/crypto.php';

function telegram_get_config(?int $tenant_id): ?array {
  if ($tenant_id === null) {
    return db_one("SELECT * FROM telegram_configs WHERE tenant_id IS NULL");
  }
  return db_one("SELECT * FROM telegram_configs WHERE tenant_id=?", [$tenant_id]);
}

function telegram_send(?int $tenant_id, string $text): void {
  $cfg = telegram_get_config($tenant_id);
  if (!$cfg || (int)$cfg['enabled'] !== 1) return;

  $token = decrypt_text($cfg['bot_token_enc']);
  if (!$token) return;

  $chatId = $cfg['chat_id'];
  $url = "https://api.telegram.org/bot{$token}/sendMessage";
  $payload = [
    'chat_id' => $chatId,
    'text' => $text,
    'disable_web_page_preview' => true,
  ];

  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
  curl_setopt($ch, CURLOPT_TIMEOUT, 10);
  curl_exec($ch);
  curl_close($ch);
}
