<?php
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/helpers.php';

function auth_login_page(?string $error=null): void {
  include __DIR__ . '/../views/auth/login.php';
}

function auth_login_action(): void {
  session_start_safe();
  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  $u = db_one("SELECT * FROM users WHERE username=?", [$username]);
  if (!$u || !password_verify($password, $u['password_hash'])) {
    auth_login_page('Invalid credentials');
    return;
  }
  if ($u['status'] !== 'ACTIVE') {
    auth_login_page('User disabled');
    return;
  }
  $_SESSION['uid'] = $u['id'];
  redirect('index.php?page=dashboard');
}

function auth_logout_action(): void {
  session_start_safe();
  session_destroy();
  redirect('index.php?page=login');
}
