<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Invoices</h2>
    <table>
      <thead><tr>
        <?php if (isset($invoices[0]['tenant_name'])): ?><th>Tenant</th><?php endif; ?>
        <th>ID</th><th>Period</th><th>Status</th><th>Total</th><th>Due</th><th>Last Paid</th><th>Action</th>
      </tr></thead>
      <tbody>
      <?php foreach ($invoices as $inv): ?>
        <tr>
          <?php if (isset($inv['tenant_name'])): ?><td><?= h($inv['tenant_name']) ?></td><?php endif; ?>
          <td>#<?= (int)$inv['id'] ?></td>
          <td><?= h($inv['period_ym']) ?></td>
          <td><?= h($inv['status']) ?></td>
          <td><?= (int)$inv['total_amount'] ?></td>
          <td><?= h($inv['due_date']) ?></td>
          <td><?= h($inv['last_paid_at'] ?? '-') ?></td>
          <td>
            <?php if ($inv['status']==='UNPAID'): ?>
              <a class="btn primary" href="index.php?page=invoice_pay&id=<?= (int)$inv['id'] ?>">Pay Now</a>
            <?php else: ?>
              <span class="badge">Paid</span>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!$invoices): ?><tr><td colspan="8">No invoices</td></tr><?php endif; ?>
      </tbody>
    </table>

    <?php if (is_super($u)): ?>
      <div class="card" style="margin-top:12px;background:#f8fafc;">
        <h3>SuperAdmin: Add Discount/Extra Charge</h3>
        <form method="post" action="index.php">
          <input type="hidden" name="action" value="invoice_adjust">
          <label>Invoice ID</label><br>
          <input name="invoice_id" style="padding:8px;border-radius:8px;border:1px solid #ddd;"><br><br>
          <label>Description</label><br>
          <input name="description" value="Discount/Extra" style="width:100%;padding:8px;border-radius:8px;border:1px solid #ddd;"><br><br>
          <label>Amount (negative=discount, positive=extra)</label><br>
          <input name="amount" value="-100" style="padding:8px;border-radius:8px;border:1px solid #ddd;"><br><br>
          <button class="btn primary" type="submit">Add Line Item</button>
        </form>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
