<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();

$baseLink = is_super($u) ? ('index.php?page=backups_browse&tenant_id='.(int)($_GET['tenant_id'] ?? 0)) : 'index.php?page=backups_browse';
$dir = $_GET['dir'] ?? '';
$dir = trim($dir,'/');
?>
<div class="main">
  <div class="card">
    <h2>Browse Backups</h2>
    <div style="margin-bottom:8px;">
      Path: <span class="badge">/<?= h($dir) ?></span>
      <?php if ($dir): 
        $parts = explode('/', $dir);
        array_pop($parts);
        $up = implode('/', $parts);
      ?>
        <a class="btn" href="<?= $baseLink . ($up ? '&dir=' . urlencode($up) : '') ?>">Up</a>
      <?php endif; ?>
    </div>

    <table>
      <thead><tr><th>Name</th><th>Type</th><th>Size</th><th>Modified</th><th>Actions</th></tr></thead>
      <tbody>
      <?php foreach ($items as $it): ?>
        <tr>
          <td><?= h($it['name']) ?></td>
          <td><?= $it['is_dir'] ? 'Folder' : 'File' ?></td>
          <td><?= $it['is_dir'] ? '-' : (int)$it['size'] ?></td>
          <td><?= date('Y-m-d H:i', (int)$it['mtime']) ?></td>
          <td>
            <?php if ($it['is_dir']): 
              $next = $dir ? ($dir.'/'.$it['name']) : $it['name'];
            ?>
              <a class="btn" href="<?= $baseLink . '&dir=' . urlencode($next) ?>">Open</a>
            <?php else: ?>
              <span class="badge">Download via backup logs</span>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!$items): ?><tr><td colspan="5">Empty</td></tr><?php endif; ?>
      </tbody>
    </table>

    <div style="margin-top:10px;color:#6b7280;font-size:12px;">
      Tip: Download/Preview works from backup log rows (you can add a "Backup History" page next).
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
