<?php
/**
 * bKash PGW placeholder.
 * Real integration requires bKash official API credentials and callback verification.
 * Put credentials in settings (GLOBAL scope) and implement token + createPayment + executePayment.
 */
require_once __DIR__ . '/db.php';

function bkash_settings_get(): array {
  // Example keys: bkash_app_key, bkash_app_secret, bkash_username, bkash_password, bkash_base_url
  $rows = db_all("SELECT k,v FROM settings WHERE scope='GLOBAL' AND k LIKE 'bkash_%'");
  $out = [];
  foreach ($rows as $r) $out[$r['k']] = $r['v'];
  return $out;
}

function bkash_create_payment_link(int $invoice_id): string {
  // For now: local pay page which simulates redirect flow
  return "index.php?page=invoice_pay&id=" . $invoice_id;
}
