<?php
require_once __DIR__ . '/db.php';

function session_start_safe(): void {
  if (session_status() === PHP_SESSION_NONE) session_start();
}

function current_user(): ?array {
  session_start_safe();
  if (empty($_SESSION['uid'])) return null;
  return db_one("SELECT * FROM users WHERE id=?", [$_SESSION['uid']]);
}

function require_login(): array {
  $u = current_user();
  if (!$u) {
    header("Location: index.php?page=login");
    exit;
  }
  if ($u['status'] !== 'ACTIVE') {
    http_response_code(403);
    exit('User disabled');
  }
  return $u;
}

function is_super(array $u): bool {
  return in_array($u['role'], ['super_admin','super_staff'], true);
}

function is_tenant_admin(array $u): bool {
  return $u['role'] === 'tenant_admin';
}

function is_tenant_staff(array $u): bool {
  return $u['role'] === 'tenant_staff';
}

function tenant_id_of(array $u): ?int {
  return $u['tenant_id'] ? (int)$u['tenant_id'] : null;
}
