<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Staff — <?= h($tenant['name']) ?> (Tenant #<?= (int)$tenant['id'] ?>)</h2>

    <?php if (!empty($_GET['msg'])): ?><div class="banner">Saved.</div><?php endif; ?>
    <?php if (!empty($_GET['err']) && $_GET['err']==='required'): ?><div class="banner" style="background:#fff7ed;border-color:#fdba74;">Username & password required.</div><?php endif; ?>
    <?php if (!empty($_GET['err']) && $_GET['err']==='exists'): ?><div class="banner" style="background:#fff7ed;border-color:#fdba74;">Username already exists.</div><?php endif; ?>
    <?php if (!empty($_GET['err']) && $_GET['err']==='pass_required'): ?><div class="banner" style="background:#fff7ed;border-color:#fdba74;">New password required.</div><?php endif; ?>

    <div class="card" style="background:#f8fafc;">
      <h3>Add Staff</h3>
      <form method="post" action="index.php">
        <input type="hidden" name="action" value="staff_create">
        <?php if (is_super($u)): ?>
          <input type="hidden" name="tenant_id" value="<?= (int)$tenant['id'] ?>">
        <?php endif; ?>

        <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
          <div>
            <label>Username</label><br>
            <input name="username" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
          </div>
          <div>
            <label>Password</label><br>
            <input type="password" name="password" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
          </div>
        </div>

        <div style="margin-top:10px;">
          <label>Role</label><br>
          <select name="role" style="width:260px;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="tenant_staff">Tenant Staff</option>
          </select>
          <div style="font-size:12px;color:#6b7280;margin-top:4px;">
            Note: Viewer/Operator roles removed as per your instruction.
          </div>
        </div>

        <button class="btn primary" type="submit" style="margin-top:10px;">Create Staff</button>
      </form>
    </div>

    <h3 style="margin-top:16px;">Users</h3>
    <table>
      <thead><tr><th>ID</th><th>Username</th><th>Role</th><th>Status</th><th>Created</th><th>Actions</th></tr></thead>
      <tbody>
        <?php foreach ($staff as $s): ?>
          <tr>
            <td><?= (int)$s['id'] ?></td>
            <td><?= h($s['username']) ?></td>
            <td><?= h($s['role']) ?></td>
            <td><?= h($s['status']) ?></td>
            <td><?= h($s['created_at']) ?></td>
            <td>
              <form method="post" action="index.php" style="display:inline;" onsubmit="return confirm('Toggle status?');">
                <input type="hidden" name="action" value="staff_toggle">
                <?php if (is_super($u)): ?><input type="hidden" name="tenant_id" value="<?= (int)$tenant['id'] ?>"><?php endif; ?>
                <input type="hidden" name="user_id" value="<?= (int)$s['id'] ?>">
                <button class="btn" type="submit"><?= $s['status']==='ACTIVE'?'Disable':'Enable' ?></button>
              </form>

              <form method="post" action="index.php" style="display:inline;" onsubmit="return confirm('Reset password?');">
                <input type="hidden" name="action" value="staff_reset_password">
                <?php if (is_super($u)): ?><input type="hidden" name="tenant_id" value="<?= (int)$tenant['id'] ?>"><?php endif; ?>
                <input type="hidden" name="user_id" value="<?= (int)$s['id'] ?>">
                <input type="password" name="new_password" placeholder="new pass" style="width:140px;padding:8px;border-radius:10px;border:1px solid #ddd;">
                <button class="btn primary" type="submit">Reset</button>
              </form>

              <?php if ($s['role']==='tenant_admin'): ?>
                <span style="color:#6b7280;font-size:12px;">(tenant_admin changes: super only)</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$staff): ?><tr><td colspan="6">No users</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
