<?php
require_once __DIR__ . '/db.php';

/**
 * Settings stored in `settings` table:
 * - GLOBAL scope: scope='GLOBAL', tenant_id=NULL
 * - TENANT scope: scope='TENANT', tenant_id=<id>
 */

function setting_get(string $scope, ?int $tenant_id, string $key, ?string $default=null): ?string {
  if ($scope === 'GLOBAL') {
    $row = db_one("SELECT v FROM settings WHERE scope='GLOBAL' AND tenant_id IS NULL AND k=? LIMIT 1", [$key]);
  } else {
    $row = db_one("SELECT v FROM settings WHERE scope='TENANT' AND tenant_id=? AND k=? LIMIT 1", [$tenant_id, $key]);
  }
  return $row ? (string)$row['v'] : $default;
}

function setting_set(string $scope, ?int $tenant_id, string $key, string $value): void {
  if ($scope === 'GLOBAL') {
    db_exec("INSERT INTO settings (scope, tenant_id, k, v) VALUES ('GLOBAL', NULL, ?, ?)
             ON DUPLICATE KEY UPDATE v=VALUES(v)", [$key, $value]);
  } else {
    db_exec("INSERT INTO settings (scope, tenant_id, k, v) VALUES ('TENANT', ?, ?, ?)
             ON DUPLICATE KEY UPDATE v=VALUES(v)", [$tenant_id, $key, $value]);
  }
}

function site_name(): string {
  return setting_get('GLOBAL', null, 'site_name', 'Sweet Online') ?: 'Sweet Online';
}

function site_support_email(): string {
  return setting_get('GLOBAL', null, 'support_email', 'support@example.com') ?: 'support@example.com';
}

function site_phone(): string {
  return setting_get('GLOBAL', null, 'support_phone', '+8801XXXXXXXXX') ?: '+8801XXXXXXXXX';
}

function site_address(): string {
  return setting_get('GLOBAL', null, 'support_address', 'Dhaka, Bangladesh') ?: 'Dhaka, Bangladesh';
}
